---
title: Use multiple audio outputs at once on Ubuntu 24.04
date: 2025-01-24T10:08:29+00:00
draft: false
tags:
  - sysadmin
  - ubuntu
---
Now this is a tricky one if you don't know what you're doing.
# What does audio do in Ubuntu?
Ubuntu 24.04 makes away with the old and brings in Pipewire, which is a new graph-based audio and video framework. It's compatible with PulseAudio and JACK, the predecessors.

# The easy way...
You can patch audio devices with software like Helvum. Here's what it looks like:
![[Pasted image 20250124101720.png]]As you can see, the media source is linked to my headphones via "wires". Multiple sources can go to one output, like so:
![[Pasted image 20250124102547.png]]
Apps usually only have an audio source when they are playing audio, and these automatically get patched to the default audio device as specified in Ubuntu's sound properties: 
![[Pasted image 20250124102704.png]]
The problem is if you want all audio to come out of multiple devices you can't select multiple in the sound settings. Thus comes an audio sink device.
# Audio sink?
An audio sink device is just a device which passes audio between some other devices. The idea is to set the default output device to this sink, and then patch in whatever real audio devices the other side.

To do this, we'll use PulseAudio. Run this command in the terminal.
```code
pactl load-module module-null-sink media.class=Audio/Sink sink_name=my-combined-sink channel_map=stereo
```
After you've done that, set your default audio device to the sink:
![[Pasted image 20250124112342.png]]
Finally, go into Helvum (or another Pipewire patch tool) and route the monitor_FL and monitor_FR to all your audio devices:
![[Pasted image 20250124112639.png]]
So, when audio's playing, it'll automatically connect to the sink:
![[Pasted image 20250124112849.png]]
And if you add new devices or other devices disconnect, you can just reconnect them and patch them back in.

# The Downsides
Now, there are a couple of downsides to this approach:
- Bluetooth devices are a little flakey, especially when using high-bandwidth codecs. The solution to this would be to use multiple bluetooth adapters - one for each bluetooth device.
- You have to re-patch devices when they reconnect. It's not that difficult to re-patch though, and there is probably a solution but I haven't looked too much into it.

It is the best way I've found to do it, though!